;Version 2015-12-21
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Version=b
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so

#include <GuiConstantsEx.au3>
#include <GDIPlus.au3>

#Region GDIPlusEx
Global Const $_cGDIPEX_ISBMP = 0x41455047
Global Const $_cGDIPEX_ISBUF = 0x42455047
Global Const $_sGDIPEX_IIDBMP = "{EB22CE37-EE56-458B-AD13-3FC836E8CE49}"
Global Const $_sGDIPEX_IIDBUF = "{1CB99E61-15BA-4B1F-8C7E-25D00AE60F2D}"
Global Const $_tagGDIPEX_BUFFER = "Draw int(int;int;uint); Gfx handle(); pBits ptr(); Width int(); Height int(); Stride int();"
Global Const $_tagGDIPEX_BITMAP = "Bmp handle(); Gfx handle(); Scan0 ptr(); Width int(); Height int(); Stride int(); Draw int(struct*;int;int); DrawRect int(struct*;int;int;uint;uint);"
Global $_aGDIPEX_ASMSTRUCT[1]
OnAutoItExitRegister("__GDIPlusEx_OnExit")
Global Const $_hGDIPEX_GDIPDLL = _GDIPlus_Startup()
Global Const $_hGDIPEX_MOD_GDI32 = _WinAPI_GetModuleHandle("gdi32.dll")
Global Const $_hGDIPEX_MOD_GDIPLUS = _WinAPI_GetModuleHandle("gdiplus.dll")
Global Const $_hGDIPEX_MOD_KERNEL32 = _WinAPI_GetModuleHandle("kernel32.dll")
Global Const $_hGDIPEX_MOD_USER32 = _WinAPI_GetModuleHandle("User32.dll")
Global Const $_pGDIPEX_LIB_SELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "SelectObject")
Global Const $_pGDIPEX_LIB_DELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteObject")
Global Const $_pGDIPEX_LIB_DELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteDC")
Global Const $_pGDIPEX_LIB_RELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_USER32, "ReleaseDC")
Global Const $_pGDIPEX_LIB_BITBLT = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "BitBlt")
Global Const $_pGDIPEX_LIB_GLOBALFREE = _WinAPI_GetProcAddress($_hGDIPEX_MOD_KERNEL32, "GlobalFree")
Global Const $_pGDIPEX_LIB_GFXDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDeleteGraphics")
Global Const $_pGDIPEX_LIB_BMPDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDisposeImage")
Global Const $_pGDIPEX_ASM_OBJ_QUERYIF = __GDIPlusEx_ASMCreate("0x538B4424088B5C2410890383400401B8000000005BC20C00", "0x49890883410801B800000000C3")
Global Const $_pGDIPEX_ASM_OBJ_ADDREF = __GDIPlusEx_ASMCreate("0x8B442404834004018B4004C20400", "0x834108018B4108C3")
Global Const $_pGDIPEX_ASM_OBJ_RELBUF = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B040075448B43388B531C52FFD08B433C8B53288B4B305152FFD08B43408B532052FFD08B43448B532852FFD08B433C8B532C8B4B245152FFD08B433453FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075504883EC20488B4360488B4B28FFD0488B4368488B4B40488B5350FFD0488B4370488B4B30FFD0488B4378488B4B40FFD0488B8380000000488B4B48488B5338FFD0488B43584889D9FFD04883C4205BC38B43085BC3")
Global Const $_pGDIPEX_ASM_OBJ_RELBMP = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B0400752A8B432C8B532052FFD08B43308B532452FFD08B43288B531C52FFD08B432853FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075314883EC20488B4348488B4B30FFD0488B4350488B4B38FFD0488B4340488B4B28FFD0488B43404889D9FFD04883C4205BC38B43085BC3")
Global Const $_pGDIPEX_ASM_OBJ_BUFDRAW = __GDIPlusEx_ASMCreate("0x5356578B5C24108B7424148B7C2418B8FFFFFFFF817B0847504542752E8B4C241C5183EC08C7042400000000C7442404000000008B5328528B5310528B530C5257568B5324528B434CFFD05F5E5BC21000", "0x534889CB4989D24D89C348C7C0FFFFFFFF81790C47504542754B4883EC484C894C244048C74424380000000048C744243000000000488B43404889442428488B431448894424204D31C9448B4B104D89D84C89D2488B4B38488B8388000000FFD04883C4485BC3")
Global Const $_pGDIPEX_ASM_OBJ_BUFGFX = __GDIPlusEx_ASMCreate("0x8B5424048B421CC20400", "0x488B4128C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFBITS = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPBMP = __GDIPlusEx_ASMCreate("0x8B5424048B4224C20400", "0x488B4138C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPGFX = __GDIPlusEx_ASMCreate("0x8B5424048B4220C20400", "0x488B4130C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPSCAN0 = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
Global Const $_pGDIPEX_ASM_BMPDRAW = __GDIPlusEx_ASMCreate("0x5756538B7424108B7C2414817F0847504542740E817F08475045417405E98E010000F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C289542410B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED8B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C248A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C60483C70483E9010F8F63FFFFFF83EB010F8F3FFFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554883EC20F30F7F3424F30F7F7C24104889CE4889D7817F0C47504542740E817F0C475045417405E99D010000F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFFF660F6FF0F30F7E6F10660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F4B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED4489CB4C89D74D01DA4C89E64D01EC4489C18A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C6044883C70483E9010F8F61FFFFFF83EB010F8F49FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF30F6F7C2410F30F6F34244883C420415D415C5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPDRAWRECT = __GDIPlusEx_ASMCreate("0x575653558B7424148B7C2418817F0847504542740E817F08475045417405E9DA010000F30F6F44241CF30F7E560CF30F7E5F0C0F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F858C0100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD283EC20660FD60424660FD64C2408660F7ED1660F73DA04660F7ED38B4714894424140FAFC38D04888B571889D501C2895424108B4424140FAF471001C58B46148944241C8B761889742418B800000047660F6EF8660F70FF00B801000000F30F2AF08B0C24F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1013B4C24087CE0660F70EDE18B5C24048B7C24108B44241401442410F30F2AC3F30F59C5F30F2CC08B7424180FAF44241C01C68B0C248B548D008A4416033C000F8488000000660F6E04163CFF747B660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10D0F30F58D1F30F53E2660F70D9000F59CB660F70D8000F59C3660F70E4000F58C10F59C4F30F10C20F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C70483C1013B4C24080F8C58FFFFFF83C3013B5C240C0F8C25FFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5D5B5E5FC21800", "0x660F6E4C2428660F6E442430660F62C85756535541544155415641574883EC30F30F7F3424F30F7F7C2410F3440F7F4424204889D74889CE817F0C47504542740E817F0C475045417405E9FA01000066410F6EC066410F6ED1660F73FA04660FEBC2660F73F908660FEBC1F30F7E5610F30F7E5F100F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F85940100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD266490F7EC04D89C149C1E92066490F7ECA4D89D349C1EB20660F7ED1660F73DA04660F7ED34831C08B47184989C50FAFC3678D04884C8B67204C89E54901C44C89E80FAF47144801C58B46184989C74C8B7620B800000047660F6EF8660F70FF00B801000000F30F2AF04831C94489C1F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1014439D17CE14831D2660F70EDE14489CB4C89E74D01ECF30F2AC3F30F59C5F3480F2CC04C89F6410FAFC74801C64489C18B548D008A4416033C000F848C000000660F6E04163CFF747F660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF3440F10C0F3440F58C1F3410F53E0660F70D900660F70D0000F59CB0F59C2660F70E4000F58C10F59C4F3410F10C00F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C70483C1014439D10F8C54FFFFFF83C3014439DB0F8C28FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF3440F6F442420F30F6F7C2410F30F6F34244883C430415F415E415D415C5D5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPCLONE = __GDIPlusEx_ASMCreate("0x5756538B7C24108B7424148B7614F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F858F00000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C2895424108B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C24F30F6F06F30F7F0783C61083C71083E9047FED83EB017FCD83C420B800000000EB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554889CF4889D6488B7628F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFED660F6FE0F30F7E5F10660FEACB660FEEC5660FFAC8660F6FD0660FFAD4B801000000660F6EE8660F70EDE0660F66E9660FD7C583F8000F858F00000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F44489CB4C89D74D01DA4C89E64D01EC4489C1F30F6F06F30F7F074883C6104883C71083E9047FEB83EB017FD748C7C000000000EB0748C7C0FFFFFFFF415D415C5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPTRANS = __GDIPlusEx_ASMCreate("0x578B7C2408660F6E7C240C660F70FF00B800000047660F6EF0660F70F600B8FFFFFF00660F6EE8660F70ED008B4F100FAF4F148B7F18660F6F07660F6FC8660FDBC5660F72D118660FFECE0F5CCE0F59CF0F58CE660FFACE660F72F118660FEBC1660F7F0783C71083E9107FC95FC20800", "0x660F70E900B800000047660F6EE0660F70E400B8FFFFFF00660F6ED8660F70DB008B41140FAF4118488B4920660F6F01660F6FC8660FDBC3660F72D118660FFECC0F5CCC0F59CD0F58CC660FFACC660F72F118660FEBC1660F7F014883C11083E8107FC8C3")
Global Const $_pGDIPEX_ASM_BMPCLR = __GDIPlusEx_ASMCreate("0x8B542404660F6E442408660F70C0008B4A100FAF4A148B5218660F7F0283C21083E9107FF4C20800", "0x660F6EC2660F70C0008B51140FAF5118488B4920660F7F014883C11083EA107FF3C3")
Global Const $_pGDIPEX_ASM_WARPMXPREP = __GDIPlusEx_ASMCreate("0x8B5424048B4C2408B801000000660F6EF8F30F2AF8660F70FF00F30F2A710C660F70F600F30F2A6910660F70ED00837C24100074060F5CF70F5CEF660F7EB250010000660F7EAA540100008B4C240C0F10010F1049100F28E00F28D80F5DE10F5FD9660F73D808660F73D9080F5DE00F5FD80F5DE10F5FD9F30F5BE4660F5BDB660FFADC660FD6A240010000660FD69A480100000F5BE4F30F7E010F5CC4660F7E7A20660FD64224660F7E7A50660FD64254F30F7E41080F5CC40F57C90F5CC80F59CE660F7E7A68660FD6426C660FD68A80000000660F7EBA98000000660FD6829C000000F30F7E41100F5CC40F57C90F5CC80F59CD660F7EBAB0000000660FD682B4000000660F7EBAE0000000660FD682E4000000660FD68AEC000000F30F7E41180F5CC40F57C90F5CC80F28D10F59CE0F59D5660F7EBAF8000000660FD682FC000000660FD68A10010000660F7EBA28010000660FD6822C010000660FD69234010000660F7EB288000000660F7EAAF4000000660F7EB218010000660F7EAA3C010000C21000", "0x4883EC20F30F7F3424F30F7F7C2410B801000000660F6EF8F30F2AF8660F70FF00F30F2A7210660F70F600F30F2A6A14660F70ED004983F90074060F5CF70F5CEF660F7EB150010000660F7EA954010000410F1000410F1048100F28E00F28D80F5DE10F5FD9660F73D808660F73D9080F5DE00F5FD80F5DE10F5FD9F30F5BE4660F5BDB660FFADC660FD6A140010000660FD699480100000F5BE4F3410F7E000F5CC4660F7E7920660FD64124660F7E7950660FD64154F3410F7E40080F5CC40F57C90F5CC80F59CE660F7E7968660FD6416C660FD68980000000660F7EB998000000660FD6819C000000F3410F7E40100F5CC40F57C90F5CC80F59CD660F7EB9B0000000660FD681B4000000660F7EB9E0000000660FD681E4000000660FD689EC000000F3410F7E40180F5CC40F57C90F5CC80F28D10F59CE0F59D5660F7EB9F8000000660FD681FC000000660FD68910010000660F7EB928010000660FD6812C010000660FD69134010000660F7EB188000000660F7EA9F4000000660F7EB118010000660F7EA93C010000F30F6F7C2410F30F6F34244883C420C3")
Global Const $_pGDIPEX_ASM_WARPMXSLVE = __GDIPlusEx_ASMCreate("0x575653558B6C2414B800000080660F6EF883C52031C90F57C00FB6D989D889C26BD20900CA660F6E4C95000F28D70F55D10F28CA0FC2C806660FD7D1F7C20F0000007406F30F10C289C383C00183F8077ECC89DA6BD20900CA837C9500000F841D01000038CB74330FB6F989DE6BFF096BF60931C08D1406660F6E4495008D1C07660F6E4C9D00660F7E4C9500660F7E449D0083C00183F8087EDA0FB6D16BD20A8B44950083F8000F84D3000000660F6EC00FB6F16BF60988CD0FB6D501F2660F6E4C9500F30F5EC8660F7E4C950080C50180FD087EE388CD80C50180FD077F3F0FB6FD6BFF0989FA00CA660F6E4495000FB6C189FA89F301C201C3660F6E4C9500660F6E549D00F30F59D0F30F5CCA660F7E4C950083C00183F8087ED6EBB980C10180F9070F8EEAFEFFFF8B7C2414B90700000089CA6BD20983C208660F6E449500660F7E048F89CB83C30183FB077F2689CA6BD20901DA660F6E449500660F6E0C9F660F6E148FF30F59C8F30F5CD1660F7E148FEBD283E9017DB831C0EB05B8FFFFFFFF5D5B5E5FC20400", "0x5756534889CF488D7120B800000080660F6EE84831C90F57C04889CB4889D84889C2486BD2094801CA660F6E0C960F28D50F55D10F28CA0FC2C806660FD7D1F7C20F0000007407F30F10C24889C34883C0014883F8077EC74889DA486BD2094801CA833C96000F84350100004839CB74374989C84989D94D6BC0094D6BC9094831C0498D1401660F6E0496498D1C00660F6E0C9E660F7E0C96660F7E049E4883C0014883F8087EDA4889CA486BD20A8B049683F8000F84E6000000660F6EC04989CA4D6BD2094989C94C89CA4C01D2660F6E0C96F30F5EC8660F7E0C964983C1014983F9087EE24989C84983C0014983F8077F444D89C14D6BC9094C89CA4801CA660F6E04964889C84C89CA4C89D34801C24801C3660F6E0C96660F6E149EF30F59D0F30F5CCA660F7E0C964883C0014883F8087ED3EBB24883C1014883F9070F8ED0FEFFFF48C7C1070000004889CA486BD2094883C208660F6E0496660F7E048F4889CB4883C3014883FB077F284889CA486BD2094801DA660F6E0496660F6E0C9F660F6E148FF30F59C8F30F5CD1660F7E148FEBCE4883E9017DB031C0EB05B8FFFFFFFF5B5E5FC3")
Global Const $_pGDIPEX_ASM_WARPVAL = __GDIPlusEx_ASMCreate("0x57568B7C240C8B742410B907000000660F6E048E660F70C00089CAC1E2040F29041783E9017DE8B801000000F30F2AC0660F70C0000F298780000000B803000000F30F2AC0660F73F804B802000000F30F2AC0660F70C0D2660F73F8040F298790000000660F6E8650010000660F6E8E54010000660F70C000660F70C9000F2987A00000000F298FB00000008B44241489874C010000C1E802F30F2AC0660F70C0000F2987C0000000B800000047660F6EC0660F70C000660F7F8730010000F30F7E8648010000660FD687400100008B4424188987480100005E5FC21000", "0x49C7C20700000066420F6E0492660F70C0004D89D349C1E304420F2904194983EA017DE3B801000000F30F2AC0660F70C0000F298180000000B803000000F30F2AC0660F73F804B802000000F30F2AC0660F70C0D2660F73F8040F298190000000660F6E8250010000660F6E8A54010000660F70C000660F70C9000F2981A00000000F2989B00000004489814C01000041C1E802F3410F2AC0660F70C0000F2981C0000000B800000047660F6EC0660F70C000660F7F8130010000F30F7E8248010000660FD6814001000044898948010000C3")
Global Const $_pGDIPEX_ASM_WARP = __GDIPlusEx_ASMCreate("0x575653558B6C24148BBD500100008BB5540100008B8D4001000083E904660F6EF9660F70FF000F5BFF0F58BD900000000F2875100F286D400F59F70F59EF0F5875000F586D300F597D600F58BD800000008B9D44010000660F6EE3660F70E4000F5BE40F5CA58000000083EB010F2845700F288D800000000F59C40F58C70F5EC80F285D200F2855500F59DC0F59D40F58DE0F58D50F59D90F59D10F2885A00000000F288DB00000000FC2C3020FC2CA020F56C10F57C90FC2CB050F56C10F57C90FC2CA050F56C10F50C083F80F0F8495000000F30F5BD2F30F5BDB0F5BD20F5BDB0F5995C00000000F58DAF30F5BDB660F72F302660FEFC0A9010000007509660F7EDA660F6E0416660F73DB04A902000000750D660F7EDA660F6E0C16660F62C1660F73DB04A904000000750C660F7EDA660F6E0C160F16C1660F73DB04A9080000007512660F7EDA660F6E0C16660F73F90C660FEBC189DA0FAF95480100008D148AF30F7F041783FB000F8FF1FEFFFF83F9000F8F9FFEFFFF5D5B5E5FC20400", "0x57564883EC20F30F7F3424F30F7F7C2410488BB950010000488BB158010000448B81400100004183E80466410F6EF8660F70FF000F5BFF0F58B9900000000F2871100F2869400F59F70F59EF0F58310F5869300F5979600F58B980000000448B894401000066410F6EE1660F70E4000F5BE40F5CA1800000004183E9010F2841700F2889800000000F59C40F58C70F5EC80F2859200F2851500F59DC0F59D40F58DE0F58D50F59D90F59D10F2881A00000000F2889B00000000FC2C3020FC2CA020F56C10F57C90FC2CB050F56C10F57C90FC2CA050F56C10F50C083F80F0F849B000000F30F5BD2F30F5BDB0F5BD20F5BDB0F5991C00000000F58DAF30F5BDB660F72F302660FEFC04831D2A9010000007509660F7EDA660F6E0416660F73DB04A902000000750D660F7EDA660F6E0C16660F62C1660F73DB04A904000000750C660F7EDA660F6E0C160F16C1660F73DB04A9080000007512660F7EDA660F6E0C16660F73F90C660FEBC14489CA0FAF914801000067428D1482F30F7F04174183F9000F8FE9FEFFFF4183F8000F8F93FEFFFFF30F6F7C2410F30F6F34244883C4205E5FC3")
Global Const $_pGDIPEX_ASM_WARPIP = __GDIPlusEx_ASMCreate("0x575653558B6C241483EC048BBD500100008BB5540100008B8D40010000890C24832C2404660F6E3C24660F70FF000F5BFF0F58BD900000000F2875100F286D400F59F70F59EF0F5875000F586D300F597D600F58BD800000000F29BDD00000000F29B5E00000000F29ADF00000008B9D4401000083EB01F30F2AFB660F70FF000F2845700F288D800000000F59C70F5885D00000000F5EC80F2875200F286D500F59F70F59EF0F58B5E00000000F58ADF00000000F59F10F59E90F2885A00000000F288DB00000000FC2C6020FC2CD020F56C10F57C90F57D20FC2CE050FC2D5050F56C10F56C20F50C083F80F0F8434010000F30F5BFEF30F5BC50F5BFF0F5BC00F5CF70F5CE80F5985C00000000F58F8F30F5BFF660F72F7020F29AD200100000F29B5100100000F29BD000100000F288D30010000660FEFC0B903000000660F73F804A9080000000F85B90000008B948D00010000F30F7E3C1603954C010000F30F7E3416660FEFD2660F60FA660F60F2660F6FEF660F6FE6660F60FA660F60F2660F68EA660F68E2660FFEF9660FFEF1660FFEE9660FFEE10F5CF90F5CF10F5CE90F5CE1660F6E9C8D100100000F289580000000660F70DB000F5CD30F59FA0F59F20F59EB0F59E30F58FD0F58F4660F6E9C8D200100000F289580000000660F70DB000F5CD30F59FA0F59F30F58FE0F58F9660FFAF9660FEFD2660F6BFA660F67FAF30F10C7D1E083E9010F8D2CFFFFFF89DA0FAF95480100008B0C248D148AF30F7F041783FB000F8F44FEFFFF833C24000F8FE6FDFFFF83C4045D5B5E5FC20400", "0x57564881ECA0000000F30F7F3424F30F7F7C2410F3440F7F442420F3440F7F4C2430F3440F7F542440F3440F7F5C2450F3440F7F642460F3440F7F6C2470F3440F7FB42480000000F3440F7FBC2490000000488BB950010000488BB158010000440F28A180000000448B81400100004831D24183E80466450F6EF866450F70FF00450F5BFF440F58B990000000440F287110440F286940450F59F7450F59EF440F5831440F586930440F597960450F58FC448B89440100004183E901F3410F2AF9660F70FF000F284170410F28CC0F59C7410F58C70F5EC8440F285120440F284950440F59D7440F59CF450F58D6450F58CD440F59D1440F59C90F2881A00000000F2889B0000000410FC2C202410FC2C9020F56C10F57C90F57D2410FC2CA05410FC2D1050F56C10F56C20F50C083F80F0F8424010000F3450F5BDAF3410F5BC1450F5BDB0F5BC0450F5CD3440F5CC80F5981C0000000440F58D8F3450F5BDB66410F72F3020F288930010000660FEFD2660FEFC041BA03000000660F73F80466450F70DB93A9080000000F859E00000066440F7EDAF30F7E1C1603914C010000F30F7E2416660F60DA660F60E2660F6FEB660F6FF4660F60DA660F60E2660F68EA660F68F2660FFED9660FFEE1660FFEE9660FFEF10F5CD90F5CE10F5CE90F5CF166450F70C2FF410F28FC410F5CF80F59DF0F59E7410F59E8410F59F00F58DD0F58E666450F70C1FF410F28FC410F5CF80F59DF410F59E00F58DC0F58D9660FFAD9660F6BDA660F67DAF30F10C366410F73FA0466410F73F904D1E04183EA010F8D34FFFFFF4489CA0FAF914801000067428D1482F30F7F04174183F9000F8F53FEFFFF4183F8000F8F03FEFFFFF3440F6FBC2490000000F3440F6FB42480000000F3440F6F6C2470F3440F6F642460F3440F6F5C2450F3440F6F542440F3440F6F4C2430F3440F6F442420F30F6F7C2410F30F6F34244881C4A00000005E5FC3")
Global Const $_pGDIPEX_ASM_FXBLUR = __GDIPlusEx_ASMCreate("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
		"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
Global Const $_pGDIPEX_ASM_FXGREY = __GDIPlusEx_ASMCreate("0x8B5424040F107C24048B4A100FAF4A148B5218660F73DF04B8FF000000F30F2AF0660F70F6000F59FEF30F5BFF660F6BFF660FEFF6660F6F02660F6FC8660F6FE0660F60C6660F68CE660F72D418660FF5C7660FF5CF660F72F418660F70D0B1660F70D9B1660FFEC2660FFECB660F72D008660F72D108660F6BC1660F70C8FA660F70C050660F67C1660F72F008660F72D008660FEBC4660F7F0283C21083E9107F92C21000", "0x4883EC10F30F7F34248B51140FAF5118488B4920660F6FE9660F73FA04660F73FB08660FEBEA660FEBEBB8FF000000F30F2AF0660F70F6000F59EEF30F5BED660F6BED660FEFF6660F6F01660F6FC8660F6FE0660F60C6660F68CE660F72D418660FF5C5660FF5CD660F72F418660F70D0B1660F70D9B1660FFEC2660FFECB660F72D008660F72D108660F6BC1660F70C8FA660F70C050660F67C1660F72F008660F72D008660FEBC4660F7F014883C11083EA107F91F30F6F34244883C410C3")
#EndRegion


_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $bExit, $iBlur = 3
Global Const $fPI = ACos(-1), $fRad = $fPI / 180, $fPI8 = $fPI / 8, $sTitle = "GDI+ Wave v1.2.1 / FPS: "
AutoItSetOption("GUIOnEventMode", 1)

GDIPlus_Wave()

AutoItSetOption("GUIOnEventMode", 0)
_GDIPlus_Shutdown()
ConsoleWrite("The end." & @CRLF)

Func GDIPlus_Wave()
	$bExit = False
	Local Const $iW = 500, $iH = 450
	$hGUI = GUICreate($sTitle & 0, $iW, $iH)
	GUISetState(@SW_SHOW, $hGUI)

	Local $oBuffer = _GDIPlusEx_BufferCreate($hGUI)
;~ 	_GDIPlus_GraphicsSetSmoothingMode($oBuffer.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBuffer.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)
	Local Const $hBrush = _GDIPlus_BrushCreateSolid(0xFF0000FF)

	Local Const $iDots_X = 32, $iDots_Y = 32, $iDots_Diameter = 16, $iDots_Radius = $iDots_Diameter / 2, $iDots_Distance = 13, $fRadius = 4.5
	Local $iX, $iY, $aCoords[$iDots_Y][$iDots_X][3], _
		  $iPos_X = (-$iDots_Diameter + $iW - ($iDots_Diameter + ($iDots_X - 1) * $iDots_Distance)) / 2, _
		  $iPos_Y = (-$iDots_Diameter + $iH - ($iDots_Diameter + ($iDots_Y - 1) * $iDots_Distance)) / 2

	Local Const $hBitmap = _GDIPlus_BitmapCreateFromMemory(_AutoIt())
	Local Const $hBitmap_Flag = _GDIPlus_ImageResize($hBitmap, $iDots_X, $iDots_Y)
	For $iY = 0 To UBound($aCoords) - 1
		For $iX = 0 To UBound($aCoords, 2) - 1
			$aCoords[$iY][$iX][2] = _GDIPlus_BitmapGetPixel($hBitmap_Flag, $iX, $iY)
		Next
	Next
	_GDIPlus_ImageDispose($hBitmap)
	_GDIPlus_ImageDispose($hBitmap_Flag)

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)
	Local $fSpeed = -2^32 + 1, $fFrequenz = 2.5, $iSub, $iR, $iG, $iB, $t
	Do
		DllCall($__g_hGDIPDll, "int", "GdipGraphicsClear", "handle", $oBuffer.Gfx, "dword", 0xFF606060)

		For $iY = 0 To UBound($aCoords) - 1
			For $iX = 0 To UBound($aCoords, 2) - 1

				$t = ($fSpeed + $iX + $iY) / $fFrequenz

				$iSub = Int(Sin($t * 0.9) * $fRadius * 8)

				$iR = BitAND(BitShift($aCoords[$iY][$iX][2], 16), 0xFF) + $iSub
				$iR = $iR < 0 ? 0 : $iR > 0xFF ? 0xFF : $iR

				$iG = BitAND(BitShift($aCoords[$iY][$iX][2], 8), 0xFF) + $iSub
				$iG = $iG < 0 ? 0 : $iG > 0xFF ? 0xFF : $iG

				$iB = BitAND($aCoords[$iY][$iX][2], 0xFF) + $iSub
				$iB = $iB < 0 ? 0 : $iB > 0xFF ? 0xFF : $iB

				DllCall($__g_hGDIPDll, "int", "GdipSetSolidFillColor", "handle", $hBrush, "dword", 0xF8000000 + 0x10000 * $iR + 0x100 * $iG + $iB)

				DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $oBuffer.Gfx, "handle", $hBrush, _
									   "float", $iPos_X + $aCoords[$iY][$iX][0], _
									   "float", $iPos_Y + $aCoords[$iY][$iX][1], _
									   "float", $iDots_Diameter, "float", $iDots_Diameter)

				$aCoords[$iY][$iX][0] = $iDots_Radius + $iX * $iDots_Distance + Cos(1.25 * $t) * $fRadius
				$aCoords[$iY][$iX][1] = $iDots_Radius + $iY * $iDots_Distance + Sin($t * 1.1) * $fRadius

			Next
		Next
		$fSpeed += 0.8
		_GDIPlusEx_EffectBlurBitmap($oBuffer, 1 + Abs(Int(Cos(-$fSpeed / 314) * 5)))
		_GDIPlus_GraphicsDrawString($oBuffer.Gfx, "Coded by UEZ / Eukalyptus", 2, $iH - 12, "Arial", 7.5)
		_GDIPlusEx_BufferDraw($oBuffer)
		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	_GDIPlus_BrushDispose($hBrush)
	$oBuffer = Null
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_Wave

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc   ;==>CalcFPS

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-09-19

Func _AutoIt($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $AutoIt
	$AutoIt &= 'iVBORw0KGgoAAAANSUhEUgAAAHsAAAB7CAIAAADbpWgoAAA+9UlEQVR4XtyWbYsxURzGJx9AMct+dtGK2EhShIQhSXhBGs9jZu47IQoJycPO7NX8m1c2sdnOtr8X0/nPHKfp53KF+/gWuq7T9e+Pz4YjBQ8BBU8fsfhVI7FeryVJajQa5XK5UCgIgoBFs9nEzeVyud/vD4fD8XjEzvvP5+718uOQBfbj5XJZrVb1ej0UCr0Z+P3+d5NgMOjz+XDT4/GEw+FKpTKZTDabDdSfz2dSf1sjZZwG9nawZjiCxWKRyWTcbjcsRyKReDyeSqWy2axggJjncjlsSCaTsVgMxr1eL+yn02lFUSj18H7bhoUzsFiwYImmafQarEa4QGATiQSk8zzvcDheTOx2u81moytvQo9enU6r1Tqfz9E5oijix7Hb7U6nk2bwpVvmPc5+hBrEkzokGo0iwqVSCa2Cvm632/1+fzgcjiRpZIAGHwwG3W4XfrGhWq0Wi0VEHnl3uVw4BB+ZzWbb7fY67ASnP8jT/w8w9z6dTlHNgUAAHYKo1mq1VqvV6/UgV5ZlVVX/Gfw3waAqCh7hm+h0OvCONs/n8+gZKhmcMB6PUe7XzQ4+m3vPLruO7L4b957bMQc0OiFnkAAIgAQJJpBDkCApJnD0cB7ZsuaVl144LdtrWX6n8AkkS7ZsyZY18nhmpOXReAI5Q1IDimACSRAkCIDIsQE00DmHm/2r+vfZOH0uugWCHC8XLqqrzj3nnlP/2rX3rl279kndMR9gsHy9VRuGpWWr2pH5LrQT9BX5AlXSjRs3IOry8vLGxkb4Q3V1dWVlJdUgCDgnkUhwDjCpYCkZBFwf+JRKpcp8UhXGgm7DJWoCPygo7L6pO8NaF39dVYMJDggfnJmZIWdgogBwEHHEt7SZZlCgbTSy0qfa2toqn0CKg2Bkt7sd9j02NoZUBCx4NHDX1NQAt7ATxILbbm3JquoYSzo4MDBw9OhRCNxAj976ThAXZF+9KhRAFsYHrfGggOuoI59PJJPWcnIhrqZOTU1xQt4TPq2CDnVyXV2dE2VtbeRUAYA+WHhIwYLJgZtrgVvUzbeCOJqTSnFIhEm344jpl/39/Wgv/JroIAp6KgbEr5qfCGiomGeCRV69ehVypp0VFRXkDQ0NwKShKrjVflL0co1ZwZ7zCejprZGREQQX3wJ6V1dXZ2cnPwgcRv5RuDkTXJZ4ZUNwR4Ez6qaDUf6gCcPH4F6zZs3jjz/OVQIBfLlEdMBgBXS4uUAnUTDEv7Sidsd6GFjwEMgcGgDoVZ4zAIoeqxyi9kBrqBrWFMAgISzCJNwFOjnJoZ7L0VQmgeSIPjCFeJcuXbpixQpgVbOFF91z5MiRxoYGThDv5u5w5xjLpopmgkhct26dkI0mBOz27dvpXcoai8DqiMAjPj01hUymLzkouNXx4lC/ckUbSkHNAgVYszhvZUWFIyv/NCZ2SrE2fhJjoga6cNdYpiB6F+4kbjc1OZXL5+A2oNbe3s5gAnppIxyEpUgYiHeVJhQPlHTImRMMdH5ZhRdeeAHE7akkimgsow2NE1YJ4tx35cqV3Ij2Otx/dWxaVY10NC2Ag5qgaAk9IZ3yQ15AG8TKgbk4dxQb3CosSqWEuPWrSD6G+wygT08jLTCJcPc1q1e3tbefPXMG5QQCB2sexFi2daoK6lrxN3rrqaee4iA//hd/8ReiEru1u9I/P8dpmYQ5cKMjIp+4F3CnlGJI3T6gC3NtzoS+PvnkE2YNHJTiRfPEr8VGYsxasN6ENFZVwZLO98nuCwRG9eKnAJ+urq7NZGBiPA/5FydOnDt3HlRAH0RE8lxunRd7jNLEz8Iuli9fHj1ZjF9VsS8gBvSx0TH0RchOCKRKpfntALpw0shi2MIo6XDJJeAGa8EtoIW1UW4cVqsumErHAclm7dwdaod5GcmL13MCQAM3FMA5Cyh/GjelrTa+x+1j1wpxUXoFqbICHRTEpYC65t8B'
	$AutoIt &= 'S1kY7u7u7vfffx8NpEFyKULaUQYyB1mBftvJLi/Mf5UQSXJTKTZhcjfyUs60z4X7ddOmTegzEoCO83gmDqcOn7wY6yGTovBMERkMDdA1zwAN3c+gvBOF2tgRjwKvxPRQU1tLf4pLkoyHCOuFWyh5mMlkZ3yS7heb79EYCAjpKxYcFXoxjiwsrKyk02KkY7zYw8q/W485jFYwcXSt++67D5H77LPP0hm6VmDrEsYTU7jBoSGEJyyIPlvtEwV3xpdi4vNpgWjWTCi4k0hbnEQsO0bXpQlQp6amR8dGR0dGkXKobhzhdMAh527ZXF6IQJfCVN+CNSOIe9X7xD2l/y2c9LtWuM2vGB9YrzBXAcLWrVvXrl27c+dObmonWE9LcaIVLGjQQ1e6u5GhwL1+/XrEb0p4KY8W/sGqTaaBAGsOWhQoY+Ks9XCLtMUlSTHSU5k2QAX9ff3DI6PoFE6TzReGR6eGR6fHxmcmpjJT05npdLZYKOYKRV0JG6DrqqvKq6vK6msr+bQ0VdfVjN/o7eU4jLOhvn5xK/8WM6RKqd4I3LiZaDIqD6LCOsrEsOJi8AKyZcuWQVLbtm2DxoWy/az1U+wuOT9RIAcuN9K/in0ZToKpHosatmOo2zgJeh//rMFqhXEwP7O/AUwIspl0dmBo6lrfaN/AeCa7iM5qX9Lc3tm6uLmhrtbNTurrahgh1tPjE1PpdHZsfHJoZHxwcPTI6eHR0fHa6lRzQ2VXW8Po2ERff19iURLUOzvaeSrGwQIyGWBi36lcejIM4Xd+53fQvqBc+PIPf/jDp59+Go0l/pvKowUQVxLipdStPridKsAxA+b20FRDY6OmEjZdjrVNWEMpPT3Xh0dG0ulcT9/oucuDk9O5xc1Na1atemJ35+IWh7KoY75UV1MdOzKTzgyPjF/t6b9w6dqJc9fKy4orupphRNyrrrauE+Db23gksCzlzrBUQL9N2wYE/uSTTx4+fBj7BEcOHDjwyiuv0OTSk2OWcCEWp/FSdrFwlTnVq6++yq+wIMJYrvVqiYSkDWErkPr6+i9eujw5OTE2MXPyXN+1vvGujraHd923ZlVXTXUlVCw8YCw31e2ISIurNqGmIDV8cUsjvXXPlrWQf//A8PGTF945dKmjtWbl0vz4xPily93Lly/r6uzg2eJsdy6ju6Uk15wWELgR9PTAAw8wpuMGn9ILiwWlGICpKOXePoED949+9CMIh9UppAfUDdyyGc3ha5p2jo5eOH9xZHRkYHjy+OkbY5P5bVvWPrN3bWNDneDMu8Rf1/4o1FQWHOg6LnJSFVwSbUua+eRy286cv/r58TOVZYW1K1oy6bPI9jWrV8EcDCnDurRqB7GrsOBJoaOj49vf/rYkM7qKjG6cbU9jV0VNPWImXGWmtFRUIblNozZw/+QnP5FZWbybnhd1CwlrBuKCVRQ4Nrbuw19cHRrN3L/jrs2bVlVXVXJONpNzoBrQUskMZU0wROMhR7CCEFYS+jaGKevQulVLV6/ovNrTd+TYmbJkZtOaJV+cOHn9eu+GDeugj7ggtepcbVKqNOYwkZSN2tjUNzoYxUZy3tAjgWlmLFcgi+kqC1exEkDd4NsC3CHvVh8KbssHBgZPnT6DiDtzsf/Eub57Nq978dfuZhgAZCaLiq1RmRTgPhe6RQGP0kAeZyyCQtAb0LGa55yyLDnabGtpa911qfv6h0dOruisAwakyLq1a+DvACCSjELGlaqYGYE2IoEhLJ08n45Pe3StGWw1pYDYU2FyiAvH2+TgdPhPf/LTVJDiCaJwR433QJUv5C9ccLbv3oHxDz+7nCqvevn5x1pbGgGDceabAdxio+QkUA5xjtN4opSrFA3gKIErjxY99Kp3dbI43/jRJyeufNa9/a7O02fODA0Nr1+/jrlwIkLdehpBGWXxyifGJ2iaLGVzuJC/tBAiwAkgLrjRymU6NzaQMlgXNq3I4sqiNbfDcwBmwiiTXSI6DL3mMIMhtK9/ENL+'
	$AutoIt &= '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'
	$AutoIt &= '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'
	$AutoIt &= '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'
	$AutoIt &= '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'
	$AutoIt &= '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'
	$AutoIt &= '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'
	$AutoIt &= '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'
	$AutoIt &= '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'
	$AutoIt &= 'GQrQvr3CArCrMIWUBzVVFWz3s91AsWTIlpblZg8jZPFswrtUDfsVBlphK5bALbsgA9d2W8cgIt1ZNf5+TivcTlVKOmUS4ELpyFK3YcDH38z6hK3ZrYinnKtQjLoVqUwVGwcCJgX91lU31lfPcvD5X4tMWfQb26FcCrws5m4C6l2+9WIZZ4MdHICr6C2zEIqUbhDXrEdwx5Q84XBnVX7rDpNA13CTIy/8hNf0HDt6lBBXaFTMI4iEzmohBiBFC2VCLeY+B3SS+AD8OMaCjO36M24NqNXNoh27ZBbrHHRAwpHKvaLKa4G8bxFpJIdLOAnPb+8Fi0XKiDHVr1KdtdbG9m8vXFWuAkl+y+U+KcogzBGdHTqSpcNPBkmhbUEA2/UWpEV5FM2EYapi5PDNcAQaH6XXJjQPhagZdDjBKnwybHBwYBD1j/dtc0Q8BKxtjRgTlTb+aptH6UrxV6xqLT8ermPhaixMv0AHbgUqhr2I/ekFRc75Ati98qgU2gMFmfAT4jGJZ75VoYZz84jBbZjbulNCRK0taPT6rP/UqMNayh8hKxGVPCrIgrVWc8CaFQbgpsrAFXXHQhx9LdWU4Xj7ArfUd1RJHMZeuQruhKc5c/oMOaRE2yCcuto6BKreOlnmE5fIPzGy2BpD3WIBxEndRswcW6NWfbAW+gTkuHgjI/ERJEQiJm9oAr4h30xxEqp6dYZmzhaVZD5z051XpR3aodtULRdQDERcsEvIShGvICvCjBGqBtM+LcQjgxz1EeZe4ROax2zs18D9s/Dl4Bjj+HENxHz1faYVNt1dmt80aYotIxPjPlETKZinIOQspbv0zdF2u1IV7itWTTv82iSDbbsX7iM+CXpiWVMApxoSLfTU7lCvdLh7ci/jX2znVUnnKnaaoC7aFhNgJsGyZ3xC+SMRBgqiphedg6p3oWIIyhDY7JOwtg1q89HT1waRaPzLXnyb55D0+krRO7ijGOgNlsyboDhO0Jv6YP6ALkmg6GICfT4IABphrD2ZckNBG3Ub/cKkjTUy3wOogBZdUxXQlEkcNzZSOo5/FdVb0/hX1/OtrJEu3EXyY2ES7YMOJwhocCE3pzvyRJhis0fbQwVdK/y+y2fcohoQCGipT5IrpPpIohrHuiT9ikA3S1acQm+nSlqgKtxTYbLhrBfkKte7F2QwUFk7iM0qQlkcnqrYiKk6aH4yqyB1YUr8q2udnbAIaJLEo5IBrXNuk66/ZkIUH/+Vdqk1KSJXQ1YbJrCmKrj1LTSrLdyyrVOw8PsgpYLNA3RQQCsBtKlMltQNnPxlecjXTOOxH/0VVVWQJqCWi8uL4VgfqGwpF6Zbxk0XdsoNa8FqSUdsnC0wKBdeHrD0Vatx2+H/rWQkr2TIgrLllgpzk7COgm4EbrkVouL3Dhr4tQ/9uK5ym0rl16xKqjxPuiWBR2kwQuzxFDnz/6HkHvTLis2vPhEoBUKoxfogev58194S2TuW9guzna9HhMrZQ7kKStHyLb9VKq1aus2TKSxwuQ5+LalYku7gktL0Ze/yfwB7w0D8z1o+tQAAAABJRU5ErkJggg=='
	Local $bString = _WinAPI_Base64Decode($AutoIt)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\AutoIt_Logo_123x123.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_AutoIt

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode

Func _GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBmp = __GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRABORTED, 2, False)
	Local $oBitmap = __GDIPlusEx_BitmapCreateObject($tBmp)
	If Not IsObj($oBitmap) Then
		__GDIPlusEx_BitmapDispose($tBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreate

Func _GDIPlusEx_BitmapDraw($oBuffer, $oBitmap, $iX = 0, $iY = 0)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 2, False)
	Local $iStatus = $oBitmap.Draw($oBuffer, $iX, $iY)
	If $iStatus Then Return SetError($GDIP_ERRABORTED, 3, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapDraw

Func _GDIPlusEx_BufferCreate($hWnd, $iWidth = 0, $iHeight = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then
		Local $aSize = WinGetClientSize($hWnd)
		If $iWidth < 1 Then $iWidth = $aSize[0]
		If $iHeight < 1 Then $iHeight = $aSize[1]
	EndIf
	Local $hDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDC)
	Local $tBmpInfo = DllStructCreate("struct; uint Size; uint Width; int Height; short Planes; short BitCount; uint Compression; uint SizeImage; int XPelsPerMeter; int YPelsPerMeter; uint ClrUsed; uint ClrImportant; endstruct;")
	DllStructSetData($tBmpInfo, "Size", DllStructGetSize($tBmpInfo))
	DllStructSetData($tBmpInfo, "Width", $iWidth)
	DllStructSetData($tBmpInfo, "Height", -($iHeight + 4))
	DllStructSetData($tBmpInfo, "Planes", 1)
	DllStructSetData($tBmpInfo, "BitCount", 32)
	Local $aResult = DllCall("gdi32.dll", "handle", "CreateDIBSection", "handle", 0, "struct*", $tBmpInfo, "uint", 0, "ptr*", 0, "handle", 0, "uint", 0)
	If @error Or Not $aResult[0] Or Not $aResult[4] Then
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Local $hDib = $aResult[0]
	Local $pBits = $aResult[4]
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $pBuffer = $aResult[0]
	Local $tBuffer = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pBits; handle Gfx; handle Dib; handle DC; handle CDC; handle Wnd; handle Obj; ptr pGlobalFree; ptr pGfxDel; ptr pSelObj; ptr pDelObj; ptr pDelDC; ptr pRelDC; ptr pBitBlt; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pDraw; ptr pGetGfx; ptr pGetBits; ptr pGetW; ptr pGetH; ptr pGetStride; endstruct;", $pBuffer)
	DllStructSetData($tBuffer, "pBits", $pBits)
	DllStructSetData($tBuffer, "Dib", $hDib)
	DllStructSetData($tBuffer, "OBJ", _WinAPI_SelectObject($hCDC, $hDib))
	DllStructSetData($tBuffer, "Gfx", _GDIPlus_GraphicsCreateFromHDC($hCDC))
	DllStructSetData($tBuffer, "Width", $iWidth)
	DllStructSetData($tBuffer, "Height", $iHeight)
	DllStructSetData($tBuffer, "Stride", $iWidth * 4)
	DllStructSetData($tBuffer, "DC", $hDC)
	DllStructSetData($tBuffer, "CDC", $hCDC)
	DllStructSetData($tBuffer, "Wnd", $hWnd)
	DllStructSetData($tBuffer, "IsGDIPEX", $_cGDIPEX_ISBUF)
	DllStructSetData($tBuffer, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBuffer, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBuffer, "pSelObj", $_pGDIPEX_LIB_SELOBJ)
	DllStructSetData($tBuffer, "pDelObj", $_pGDIPEX_LIB_DELOBJ)
	DllStructSetData($tBuffer, "pDelDC", $_pGDIPEX_LIB_DELDC)
	DllStructSetData($tBuffer, "pRelDC", $_pGDIPEX_LIB_RELDC)
	DllStructSetData($tBuffer, "pBitBlt", $_pGDIPEX_LIB_BITBLT)
	DllStructSetData($tBuffer, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBuffer, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBuffer, "pRelease", $_pGDIPEX_ASM_OBJ_RELBUF)
	DllStructSetData($tBuffer, "pDraw", $_pGDIPEX_ASM_OBJ_BUFDRAW)
	DllStructSetData($tBuffer, "pGetGfx", $_pGDIPEX_ASM_OBJ_BUFGFX)
	DllStructSetData($tBuffer, "pGetBits", $_pGDIPEX_ASM_OBJ_BUFBITS)
	DllStructSetData($tBuffer, "pGetW", $_pGDIPEX_ASM_OBJ_BUFWIDTH)
	DllStructSetData($tBuffer, "pGetH", $_pGDIPEX_ASM_OBJ_BUFHEIGHT)
	DllStructSetData($tBuffer, "pGetStride", $_pGDIPEX_ASM_OBJ_BUFSTRIDE)
	DllStructSetData($tBuffer, "Vtbl", DllStructGetPtr($tBuffer, "pQueryInterface"))
	DllStructSetData($tBuffer, "RefCnt", 1)
	Local $oBuffer = ObjCreateInterface($pBuffer, $_sGDIPEX_IIDBUF, $_tagGDIPEX_BUFFER)
	If Not IsObj($oBuffer) Then
		_GDIPlus_GraphicsDispose(DllStructGetData($tBuffer, "Gfx"))
		_WinAPI_SelectObject(DllStructGetData($tBuffer, "CDC"), DllStructGetData($tBuffer, "OBJ"))
		_WinAPI_DeleteObject(DllStructGetData($tBuffer, "Dib"))
		_WinAPI_DeleteDC(DllStructGetData($tBuffer, "CDC"))
		_WinAPI_ReleaseDC(DllStructGetData($tBuffer, "Wnd"), DllStructGetData($tBuffer, "DC"))
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pBuffer)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Return $oBuffer
EndFunc   ;==>_GDIPlusEx_BufferCreate

Func _GDIPlusEx_BufferDraw($oBuffer, $iX = 0, $iY = 0, $iROP = 0x00CC0020)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $iStatus = $oBuffer.Draw($iX, $iY, $iROP)
	If Not $iStatus Then Return SetError($GDIP_ERRABORTED, 2, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BufferDraw

Func _GDIPlusEx_EffectBlurBitmap($oBitmap, $iRadius)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	$iRadius = Int($iRadius)
	If $iRadius < 1 Or $iRadius > 127 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tTmp = __GDIPlusEx_BitmapCreate($oBitmap.Width, $oBitmap.Height)
	DllCallAddress("none", $_pGDIPEX_ASM_FXBLUR, "struct*", $tTmp, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "int", $iRadius)
	__GDIPlusEx_BitmapDispose($tTmp)
	Return True
EndFunc   ;==>_GDIPlusEx_EffectBlurBitmap

Func __GDIPlusEx_ASMCreate(ByRef Const $bBC32, ByRef Const $bBC64)
	Local $iSize
	Switch @AutoItX64
		Case True
			$iSize = BinaryLen($bBC64)
		Case Else
			$iSize = BinaryLen($bBC32)
	EndSwitch
	Local $aResult = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", $iSize + 16, "dword", 0x00001000, "dword", 0x00000040)
	If @error Or Not $aResult[0] Then Return SetError(1, 0, False)
	Local $pStruct = Number($aResult[0])
	If Mod($pStruct, 16) Then $pStruct = $pStruct + 16 - Mod($pStruct, 16)
	Local $tStruct = DllStructCreate("byte[" & $iSize & "];", $pStruct)
	Switch @AutoItX64
		Case True
			DllStructSetData($tStruct, 1, $bBC64)
		Case Else
			DllStructSetData($tStruct, 1, $bBC32)
	EndSwitch
	DllCall("kernel32.dll", "bool", "VirtualProtect", "struct*", $pStruct, "ulong_ptr", $iSize, "dword", 16, "dword*", 0)
	Local $iIdx = $_aGDIPEX_ASMSTRUCT[0] + 1
	If $iIdx >= UBound($_aGDIPEX_ASMSTRUCT) Then ReDim $_aGDIPEX_ASMSTRUCT[$iIdx + 1]
	$_aGDIPEX_ASMSTRUCT[0] = $iIdx
	$_aGDIPEX_ASMSTRUCT[$iIdx] = $pStruct
	Return $pStruct
EndFunc   ;==>__GDIPlusEx_ASMCreate

Func __GDIPlusEx_BitmapCreate($iW, $iH, $iColor = 0)
	$iW = Int($iW)
	$iH = Int($iH)
	Local $iStride = $iW * 4
	If Mod($iStride, 16) Then $iStride += 16 - Mod($iStride, 16)
	Local $aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", $iStride * ($iH + 4) * 4 + 32)
	If @error Or Not $aResult[0] Then Return SetError($GDIP_ERRABORTED, 1, False)
	Local $pScan0 = Number($aResult[0])
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pScan0)
		Return SetError($GDIP_ERRABORTED, 2, False)
	EndIf
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; endstruct;", $aResult[0])
	DllStructSetData($tBitmap, "Width", $iW)
	DllStructSetData($tBitmap, "Height", $iH)
	DllStructSetData($tBitmap, "Stride", $iStride)
	DllStructSetData($tBitmap, "pScan0ORIG", $pScan0)
	If Mod($pScan0, 16) Then $pScan0 += 16 - Mod($pScan0, 16)
	DllStructSetData($tBitmap, "pScan0", $pScan0)
	DllStructSetData($tBitmap, "IsGDIPEX", $_cGDIPEX_ISBMP)
	If $iColor Then DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", $tBitmap, "uint", $iColor)
	Return $tBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreate

Func __GDIPlusEx_BitmapCreateObject($tBmp)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; handle Gfx; handle Bmp; ptr pGlobalFree; ptr pGfxDel; ptr pBmpDel; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pGetBmp; ptr pGetGfx; ptr pGetScan0; ptr pGetW; ptr pGetH; ptr pGetStride; ptr pDraw; ptr pDrawRect; endstruct;", DllStructGetPtr($tBmp))
	Local $hBmp = _GDIPlus_BitmapCreateFromScan0(DllStructGetData($tBmp, "Width"), DllStructGetData($tBmp, "Height"), $GDIP_PXF32ARGB, DllStructGetData($tBmp, "Stride"), DllStructGetData($tBmp, "pScan0"))
	Local $hGfx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	DllStructSetData($tBitmap, "Bmp", $hBmp)
	DllStructSetData($tBitmap, "Gfx", $hGfx)
	DllStructSetData($tBitmap, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBitmap, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBitmap, "pBmpDel", $_pGDIPEX_LIB_BMPDEL)
	DllStructSetData($tBitmap, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBitmap, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBitmap, "pRelease", $_pGDIPEX_ASM_OBJ_RELBMP)
	DllStructSetData($tBitmap, "pGetBmp", $_pGDIPEX_ASM_OBJ_BMPBMP)
	DllStructSetData($tBitmap, "pGetGfx", $_pGDIPEX_ASM_OBJ_BMPGFX)
	DllStructSetData($tBitmap, "pGetScan0", $_pGDIPEX_ASM_OBJ_BMPSCAN0)
	DllStructSetData($tBitmap, "pGetW", $_pGDIPEX_ASM_OBJ_BMPWIDTH)
	DllStructSetData($tBitmap, "pGetH", $_pGDIPEX_ASM_OBJ_BMPHEIGHT)
	DllStructSetData($tBitmap, "pGetStride", $_pGDIPEX_ASM_OBJ_BMPSTRIDE)
	DllStructSetData($tBitmap, "pDraw", $_pGDIPEX_ASM_BMPDRAW)
	DllStructSetData($tBitmap, "pDrawRect", $_pGDIPEX_ASM_BMPDRAWRECT)
	DllStructSetData($tBitmap, "Vtbl", DllStructGetPtr($tBitmap, "pQueryInterface"))
	DllStructSetData($tBitmap, "RefCnt", 1)
	Local $oBitmap = ObjCreateInterface(DllStructGetPtr($tBmp), $_sGDIPEX_IIDBMP, $_tagGDIPEX_BITMAP)
	If Not IsObj($oBitmap) Then
		_GDIPlus_GraphicsDispose($hGfx)
		_GDIPlus_BitmapDispose($hBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreateObject

Func __GDIPlusEx_BitmapDispose(ByRef $tBitmap)
	If Not IsDllStruct($tBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetData($tBitmap, "pScan0ORIG"))
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetPtr($tBitmap))
	$tBitmap = 0
	Return True
EndFunc   ;==>__GDIPlusEx_BitmapDispose

Func __GDIPlusEx_ObjGetPtr($oObj)
	If Not IsObj($oObj) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, 0)
	Local $pPtr
	$oObj.QueryInterface("", $pPtr)
	$oObj.Release
	Return $pPtr
EndFunc   ;==>__GDIPlusEx_ObjGetPtr

Func __GDIPlusEx_OnExit()
	If Not IsArray($_aGDIPEX_ASMSTRUCT) Or UBound($_aGDIPEX_ASMSTRUCT) < 1 Or UBound($_aGDIPEX_ASMSTRUCT, 0) <> 1 Then Return
	If $_aGDIPEX_ASMSTRUCT[0] >= UBound($_aGDIPEX_ASMSTRUCT) Then $_aGDIPEX_ASMSTRUCT[0] = UBound($_aGDIPEX_ASMSTRUCT) - 1
	For $i = 1 To $_aGDIPEX_ASMSTRUCT[0]
		DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_aGDIPEX_ASMSTRUCT[$i], "ulong_ptr", 0, "dword", 0x00008000)
	Next
	_GDIPlus_Shutdown()
EndFunc   ;==>__GDIPlusEx_OnExit